﻿WITH   RECURSIVE racine_depart(id_noeud_racine) AS (VALUES (1)),
       hierarchie(id_noeud,lib_noeud,id_noeud_pere) AS (
VALUES (1,'Service1',NULL),(2,'Service2',NULL),(3,'Service3',1),(4,'Service4',2),(5,'Service5',99),
       (6,'Service6',1),(7,'service7',6),(8,'Service8',2),(9,'Service9',5),(0,'Service0',4)),
       parcours_hierarchie(id_noeud,lib_noeud,id_noeud_pere) AS (
SELECT id_noeud,lib_noeud,id_noeud_pere
FROM   hierarchie CROSS JOIN racine_depart WHERE  id_noeud =id_noeud_racine
UNION  ALL
SELECT hierarchie.id_noeud,hierarchie.lib_noeud,hierarchie.id_noeud_pere
FROM   hierarchie JOIN parcours_hierarchie ON hierarchie.id_noeud_pere=parcours_hierarchie.id_noeud),
       liste_erreur (id_noeud,lib_noeud,id_noeud_pere) AS (
SELECT id_noeud,lib_noeud,id_noeud_pere FROM hierarchie
EXCEPT
SELECT id_noeud,lib_noeud,id_noeud_pere FROM parcours_hierarchie),
       parcours_erreur (id_noeud,lib_noeud,id_noeud_pere,description,niveau,ancetre) AS (
SELECT id_noeud,lib_noeud,id_noeud_pere,
       CASE id_noeud_pere IS NULL WHEN TRUE THEN 'Arbre orphelin'
                                  ELSE 'Noeud ancètre non existant' END,1,id_noeud 
FROM   liste_erreur WHERE  id_noeud_pere IS NULL OR NOT EXISTS
       (SELECT * FROM liste_erreur lst_bis WHERE liste_erreur.id_noeud_pere=lst_bis.id_noeud)
UNION  ALL
SELECT liste_erreur.id_noeud,liste_erreur.lib_noeud,liste_erreur.id_noeud_pere,
       description,niveau+1,ancetre
FROM   liste_erreur JOIN parcours_erreur ON parcours_erreur.id_noeud=liste_erreur.id_noeud_pere)
SELECT id_noeud AS "Id",LPAD(lib_noeud,8+3*(niveau-1),' ') AS "Désignation",
       id_noeud_pere AS "Id père",description AS "Motif rejet",niveau AS "Profondeur rejet"
FROM   parcours_erreur ORDER BY ancetre,niveau;